/* 
 *  MonitorInteractionsRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MonitoredExecutor;

public class MonitorInteractionsRequest extends MonitoredUserRequest {

    private static final Logger LOG = Logger.getLogger(MonitorInteractionsRequest.class);
    private final MonitoredExecutor monitorExe;

    public MonitorInteractionsRequest(MonitoredExecutor monitorExe, String supervisorId, String userId) {
        super(LOG, supervisorId, userId);
        this.monitorExe = monitorExe;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getMonitoredUser().monitorInteractions(monitorExe);
        LOG.trace(methodName + "-");
        return null;
    }
}
